Rem
Rem $Header: validate_georaster.sql 07-jan-2007.07:24:38 bgouslin Exp $
Rem
Rem validate_georaster.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      validate_georaster.sql
Rem
Rem    DESCRIPTION
Rem      validate georaster objects and find out the problem if there
Rem      is something wrong
Rem
Rem    NOTES
Rem      You should validate the georaster objects before you 
Rem      work further on it
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    bgouslin    01/07/07 - New version to fix Windoze format issue caused by
Rem                           some ADE bug
Rem    wexu        02/14/06 - validate blockMBR 
Rem    wexu        08/05/04 - connect as scott 
Rem    qxie        10/31/02 - qxie_demo1
Rem    qxie        10/24/02 - Created
Rem

-- connect scott/tiger;

-------------------------------------------------------------------
-- validate georaster objects
--
-- using function validateGeoRaster to validate a column
-- of georaster objects. If the georaster object is not valid,
-- an Oracle error code is returned. Check the documentation
-- for detailed explanation for each error code
-------------------------------------------------------------------

column isvalid format a10
select t.georid,
       mdsys.sdo_geor.validategeoraster(t.georaster) isvalid
  from georaster_table t order by georid;



-------------------------------------------------------------------
-- validate georaster objects against the GeoRaster XML schema
--
-- if any georaster object is not valid and the error code is 13454,
-- which means its metadata is not valid against the xml schema.
-- then call function schemaValidate to find out detailed errors
-- and their locations in the GeoRaster metadata document
-------------------------------------------------------------------

select t.georid,
       mdsys.sdo_geor.schemavalidate(t.georaster) isvalid
  from georaster_table t 
  where t.georid = 1;





-------------------------------------------------------------------
-- validate the blockMBR of the rasterBlocks
--
-------------------------------------------------------------------
select t.georid,
       mdsys.sdo_geor.validateBlockMBR(t.georaster) isvalid
  from georaster_table t order by georid;



